import React from 'react';
import { Link } from 'react-router-dom';
import { Calculator, TrendingUp, Users, Zap } from 'lucide-react';

const Home: React.FC = () => {
  const features = [
    {
      icon: Calculator,
      title: 'Advanced Numerology',
      description: 'Calculate your numerology pyramid with exact L5-L9 formulations based on your birthdate.',
    },
    {
      icon: TrendingUp,
      title: 'SWOT Analysis',
      description: 'Discover your strengths, weaknesses, opportunities, and threats through numerology combinations.',
    },
    {
      icon: Users,
      title: 'Business Guidance',
      description: 'Get personalized business recommendations based on your root number and element.',
    },
    {
      icon: Zap,
      title: 'Learning Styles',
      description: 'Understand your optimal learning approach for personal and professional growth.',
    },
  ];

  return (
    <div className="space-y-12">
      {/* Hero Section */}
      <div className="text-center text-white space-y-6">
        <h1 className="text-4xl md:text-6xl font-bold">
          SWOT Talent Numerology
        </h1>
        <p className="text-xl md:text-2xl opacity-90 max-w-3xl mx-auto">
          Discover your hidden talents, business potential, and personal strengths through the ancient science of numerology.
        </p>
        <div className="flex flex-col sm:flex-row gap-4 justify-center items-center">
          <Link
            to="/calculator"
            className="px-8 py-4 bg-white text-purple-600 font-semibold rounded-xl hover:bg-gray-100 transition-all duration-300 transform hover:scale-105 shadow-lg"
          >
            Start Your Analysis
          </Link>
          <Link
            to="/register"
            className="px-8 py-4 border-2 border-white text-white font-semibold rounded-xl hover:bg-white hover:text-purple-600 transition-all duration-300"
          >
            Create Account
          </Link>
        </div>
      </div>

      {/* Features Section */}
      <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
        {features.map((feature, index) => (
          <div
            key={index}
            className="bg-white rounded-xl shadow-lg p-6 text-center hover:shadow-xl transition-all duration-300 transform hover:-translate-y-2"
          >
            <div className="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4">
              <feature.icon className="h-8 w-8 text-purple-600" />
            </div>
            <h3 className="text-xl font-semibold text-gray-800 mb-2">
              {feature.title}
            </h3>
            <p className="text-gray-600">
              {feature.description}
            </p>
          </div>
        ))}
      </div>

      {/* How It Works Section */}
      <div className="bg-white rounded-xl shadow-lg p-8">
        <h2 className="text-3xl font-bold text-center text-gray-800 mb-8">
          How It Works
        </h2>
        <div className="grid md:grid-cols-3 gap-8">
          <div className="text-center">
            <div className="w-12 h-12 bg-purple-600 text-white rounded-full flex items-center justify-center mx-auto mb-4 text-xl font-bold">
              1
            </div>
            <h3 className="text-xl font-semibold text-gray-800 mb-2">
              Enter Your Details
            </h3>
            <p className="text-gray-600">
              Provide your name, birthdate, and industry for accurate analysis.
            </p>
          </div>
          <div className="text-center">
            <div className="w-12 h-12 bg-purple-600 text-white rounded-full flex items-center justify-center mx-auto mb-4 text-xl font-bold">
              2
            </div>
            <h3 className="text-xl font-semibold text-gray-800 mb-2">
              Get Your Analysis
            </h3>
            <p className="text-gray-600">
              Our system calculates your numerology pyramid and identifies SWOT combinations.
            </p>
          </div>
          <div className="text-center">
            <div className="w-12 h-12 bg-purple-600 text-white rounded-full flex items-center justify-center mx-auto mb-4 text-xl font-bold">
              3
            </div>
            <h3 className="text-xl font-semibold text-gray-800 mb-2">
              Apply Insights
            </h3>
            <p className="text-gray-600">
              Use your personalized insights for business decisions and personal growth.
            </p>
          </div>
        </div>
      </div>

      {/* CTA Section */}
      <div className="bg-white rounded-xl shadow-lg p-8 text-center">
        <h2 className="text-3xl font-bold text-gray-800 mb-4">
          Ready to Discover Your Potential?
        </h2>
        <p className="text-gray-600 mb-6 max-w-2xl mx-auto">
          Join thousands who have unlocked their hidden talents and business potential through our comprehensive numerology analysis.
        </p>
        <Link
          to="/calculator"
          className="inline-block px-8 py-4 bg-purple-600 text-white font-semibold rounded-xl hover:bg-purple-700 transition-all duration-300 transform hover:scale-105 shadow-lg"
        >
          Start Your Free Analysis
        </Link>
      </div>
    </div>
  );
};

export default Home;